/***************************************************************************
**
**  This file is part of QGpGuiMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2013-02-23
**  Copyright: 2013-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef CURVESELECTORITEM_H
#define CURVESELECTORITEM_H

#include "QGpGuiMathDLLExport.h"
#include "CurveProperties.h"

namespace QGpGuiMath {

  class QGPGUIMATH_EXPORT CurveSelectorItem : public QAbstractItemModel
  {
  public:
    CurveSelectorItem(QObject * parent=nullptr);
    ~CurveSelectorItem();

    void addGroup(const QString& g);
    void addCurve(CurveProperties * p);

    virtual int rowCount(const QModelIndex& parent=QModelIndex()) const;
    virtual int columnCount(const QModelIndex& parent=QModelIndex()) const;
    virtual QVariant data(const QModelIndex& index, int role) const;
    bool hasChildren (const QModelIndex& parent) const;
    virtual QModelIndex parent (const QModelIndex& index) const;
    virtual QModelIndex index (int row, int column, const QModelIndex& parent=QModelIndex()) const;
    virtual Qt::ItemFlags flags (const QModelIndex&) const;

    QList<CurveProperties *> curves(const QModelIndexList& list);
  private:
    bool isGroupItem(const QModelIndex& index) const {return index.internalId()==0;}

    QStringList _groups;
    QList<QList<CurveProperties *> > _curves;
  };

} // namespace QGpGuiMath

#endif // CURVESELECTORITEM_H
