/***************************************************************************
**
**  This file is part of QGpGuiMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2013-02-23
**  Copyright: 2013-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "CurveSelectorItem.h"

namespace QGpGuiMath {

  /*!
    \class CurveSelectorItem CurveSelectorItem.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  CurveSelectorItem::CurveSelectorItem(QObject *parent)
    : QAbstractItemModel(parent)
  {
    TRACE;
  }

  /*!
    Description of destructor still missing
  */
  CurveSelectorItem::~CurveSelectorItem()
  {
    TRACE;
  }

  void CurveSelectorItem::addGroup(const QString& g)
  {
    TRACE;
    _groups.append(g);
    _curves.append(QList<CurveProperties *>());
  }

  void CurveSelectorItem::addCurve(CurveProperties * p)
  {
    if(_curves.isEmpty()) {
      addGroup("");
    }
    _curves.last().append(p);
  }

  int CurveSelectorItem::rowCount(const QModelIndex& parent) const
  {
    TRACE;
    if(_groups.count()<2) {      // One group to hide
      if(!parent.isValid()) {
        return _curves.last().count();
      }
    } else {
      if(!parent.isValid()) {    // Several groups to show
        return _curves.count();
      } else if(isGroupItem(parent)) {
        return _curves.at(parent.row()).count();
      }
    }
    return 0;
  }

  int CurveSelectorItem::columnCount(const QModelIndex&) const
  {
    TRACE;
    return 1;
  }

  bool CurveSelectorItem::hasChildren (const QModelIndex& parent) const
  {
    TRACE;
    if(_groups.count()<2) {
      return !parent.isValid();
    } else {
      return !parent.isValid() || isGroupItem(parent);
    }
  }

  QVariant CurveSelectorItem::data(const QModelIndex& index, int role) const
  {
    TRACE;
    if(!index.isValid()) return QVariant();
    CurveProperties * p=0;
    if(_groups.count()<2) {
      p=_curves.last().at(index.row());
    } else {
      if(isGroupItem(index)) {
        switch (role) {
        case Qt::DisplayRole:
          return _groups.at(index.row());
        default:
          return QVariant();
        }
      } else {
        p=_curves.at(index.parent().row()).at(index.row());
      }
    }
    CurveProxy * px=p->proxy();
    switch (role) {
    case Qt::DisplayRole:
      return px->name();
    case Qt::ToolTipRole:
      return QString("%1 samples from %2 to %3 %4")
          .arg(px->sampleCount())
          .arg(px->minimumX())
          .arg(px->maximumX())
          .arg(px->xUnit());
    default:
      return QVariant();
    }
  }

  QModelIndex CurveSelectorItem::parent(const QModelIndex& index) const
  {
    TRACE;
    if(!index.isValid()) return QModelIndex();
    quintptr id=index.internalId(); // Index of group +1 for curve items
                                    // 0 for group items
    if(id==0) {
      return QModelIndex();
    } else {
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
      return createIndex(static_cast<int>(id)-1, 0, static_cast<quintptr>(0));
#else
      return createIndex(static_cast<int>(id)-1, 0, 0);
#endif
    }
  }

  QModelIndex CurveSelectorItem::index(int row, int column, const QModelIndex& parent) const
  {
    TRACE;
    if(!parent.isValid()) {
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
      return createIndex(row, column, static_cast<quintptr>(0));
#else
      return createIndex(row, column, 0);
#endif
    } else {
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
      return createIndex(row, column, static_cast<quintptr>(row+1)); // Index 0 is reserved for group items
#else
      return createIndex(row, column, row+1);
#endif
    }
  }

  Qt::ItemFlags CurveSelectorItem::flags(const QModelIndex& index) const
  {
    if(_groups.count()>1 && isGroupItem(index)) {
      return Qt::ItemIsEnabled;
    } else {
      return Qt::ItemIsSelectable | Qt::ItemIsEnabled;
    }
  }

  QList<CurveProperties *> CurveSelectorItem::curves(const QModelIndexList& list)
  {
    TRACE;
    QList<CurveProperties *> l;
    for(QModelIndexList::const_iterator it=list.begin();it!=list.end();++it) {
      const QModelIndex& index=*it;
      if(_groups.count()==1) {
        l.append(_curves.last().at(index.row()));
      } else {
        l.append(_curves.at(index.internalId()).at(index.row()));
      }
    }
    return l;
  }

} // namespace QGpGuiMath
