/***************************************************************************
**
**  This file is part of QGpGuiMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2013-02-20
**  Copyright: 2013-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef CURVEPROPERTIES_H
#define CURVEPROPERTIES_H

#include <QGpCoreMath.h>
#include <SciFigs.h>

#include "ui_CurveProperties.h"
#include "QGpGuiMathDLLExport.h"

namespace QGpGuiMath {

  class QGPGUIMATH_EXPORT CurveProperties : public QWidget, protected Ui::CurveProperties
  {
    Q_OBJECT
  public:
    CurveProperties(QWidget * parent=nullptr);
    virtual ~CurveProperties();

    virtual void setProxy(CurveProxy * proxy);
    CurveProxy * proxy() const {return _proxy;}

    virtual void setLine(AbstractLine * line);
    AbstractLine * line() const {return _line;}

    void setCurrentLayer(LineLayer * layer) {_currentLayer=layer;}
    virtual void setEditable(bool e);
    void setCurveVisible(bool v);

    void resample(int n, double minimum, double maximum, SamplingOptions options, bool distance);
    void cut(double minimum, double maximum, SamplingOptions options);
    void validate(double minimum, double maximum, SamplingOptions options, bool value);
    void smooth(const SamplingParameters& sampling, const SmoothingParameters& param);

    virtual void beginCurveChange();
    virtual void endCurveChange();
  private slots:
    void applyAllSelected();
    void on_curveName_textChanged(QString text);
    void on_visibleBut_toggled(bool checked);
  signals:
    void curveModified();
    void nameChanged(QString n);
  private:
    CurveProxy * _proxy;
    AbstractLine * _line;
    LineLayer * _currentLayer;
  };

} // namespace QGpGuiMath

#endif // CURVEPROPERTIES_H
