/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-10-17
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "RayleighFunction.h"

namespace QGpCoreWave {

/*!
  \class RayleighFunction RayleighFunction.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
RayleighFunction::RayleighFunction()
    : AbstractFunction()
{
  TRACE;
  _model=0;
  _rayleigh=0;
}

/*!
  Description of destructor still missing
*/
RayleighFunction::~RayleighFunction()
{
  TRACE;
  delete _rayleigh;
}

void RayleighFunction::setModel(const Seismic1DModel * m)
{
  TRACE;
  _model=m;
  _rayleigh=new Rayleigh(m);
}

/*!
  \a x is frequency in Hz, \a y is the slowness.
*/
double RayleighFunction::value(const Point& p) const
{
  TRACE;
  _rayleigh->setOmega(2.0*M_PI*p.x());
  return fabs(_rayleigh->y(p.y())/(p.x()*p.x()));
}

} // namespace QGpCoreWave
