/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-01-06
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**    Roger Wisen (RAMBOLL, Copenhagen, Denmark)
**    Phil Cummins (RSES, Canberra, Australia)
**
***************************************************************************/

#ifndef FORTRANINTERFACE_H
#define FORTRANINTERFACE_H

#include "QGpCoreWaveDLLExport.h"

#ifdef __cplusplus
extern "C"
{
#endif

#ifdef WIN32
  // Microsoft Visual Studio has special way of naming functions in dll
  // Hence here is a compatibility layer
  QGPCOREWAVE_EXPORT __stdcall void DISPERSION_CURVE_INIT(int * verbose);
  QGPCOREWAVE_EXPORT __stdcall void DISPERSION_CURVE_RAYLEIGH(int * nLayers, double * h, double * vp, double * vs, double * rho,
                                                              int * nSamples, double * omega,
                                                              int * nModes, double * slowness, int * group);
  QGPCOREWAVE_EXPORT __stdcall void DISPERSION_CURVE_LOVE(int * nLayers, double * h, double * vp, double * vs, double * rho,
                                                          int * nSamples, double * omega,
                                                          int * nModes, double * slowness, int * group);
  QGPCOREWAVE_EXPORT __stdcall void ELLIPTICITY_CURVE(int * nLayers, double * h, double * vp, double * vs, double * rho,
                                                      int * nSamples, double * omega,
                                                      int * nModes, double * ell, int * doPeaks);
  // Possibly compiling with Intel Fortran compiler under Microsoft Visual Studio
  QGPCOREWAVE_EXPORT void DISPERSION_CURVE_INIT_INTEL(int * verbose);
  QGPCOREWAVE_EXPORT void DISPERSION_CURVE_RAYLEIGH_INTEL(int * nLayers, double * h, double * vp, double * vs, double * rho,
                                                          int * nSamples, double * omega,
                                                          int * nModes, double * slowness, int * group);
  QGPCOREWAVE_EXPORT void DISPERSION_CURVE_LOVE_INTEL(int * nLayers, double * h, double * vp, double * vs, double * rho,
                                                      int * nSamples, double * omega,
                                                      int * nModes, double * slowness, int * group);
  QGPCOREWAVE_EXPORT void ELLIPTICITY_CURVE_INTEL(int * nLayers, double * h, double * vp, double * vs, double * rho,
                                                  int * nSamples, double * omega,
                                                  int * nModes, double * ell, int * doPeaks);
#endif

QGPCOREWAVE_EXPORT void dispersion_curve_init_(int * verbose);
QGPCOREWAVE_EXPORT void dispersion_curve_rayleigh_(int * nLayers, double * h, double * vp, double * vs, double * rho,
                                                   int * nSamples, double * omega,
                                                   int * nModes, double * slowness, int * group);
QGPCOREWAVE_EXPORT void dispersion_curve_love_(int * nLayers, double * h, double * vs, double * rho,
                                               int * nSamples, double * omega,
                                               int * nModes, double * slowness, int * group);
QGPCOREWAVE_EXPORT void ellipticity_curve_(int * nLayers, double * h, double * vp, double * vs, double * rho,
                                           int * nSamples, double * omega,
                                           int * nModes, double * ell, int * doPeaks);
QGPCOREWAVE_EXPORT void rayleigh_determinant_(int * nLayers, double * h, double * vp, double * vs, double * rho,
                                              double * frequency,  double * slowness, double * det);
QGPCOREWAVE_EXPORT void love_determinant_(int * nLayers, double * h, double * vs, double * rho,
                                          double * frequency,  double * slowness, double * det);

#ifdef __cplusplus
}
#endif

#endif // FORTRANINTERFACE_H
