/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-09-24
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef VECTOR_H
#define VECTOR_H

#include "Matrix.h"
#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  template <typename T> class QGPCOREMATH_EXPORT Vector : public Matrix<T>
  {
  public:
    Vector() : Matrix<T>() {}
    Vector(int nrow) : Matrix<T>(nrow, 1) {}
    Vector(const Vector<T>& o) : Matrix<T>(o) {}

    T& at(int row) {return Matrix<T>::values()[row];}
    const T& at(int row) const {return Matrix<T>::values()[row];}

    T& operator[](int row) {return Matrix<T>::values()[row];}
    const T& operator[](int row) const {return Matrix<T>::values()[row];}

    void setValues(T * val) {Matrix<T>::_d->setValues(val);}
    void detachValues() {Matrix<T>::_d->detachValues();}
  };

} // namespace QGpCoreMath

#endif // VECTOR_H

