/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-05-20
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef POINTNDOPTIONS_H
#define POINTNDOPTIONS_H

#include "PointND.h"
#include "CurvePointOptions.h"
#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

class QGPCOREMATH_EXPORT PointNDOptions : public CurvePointOptions
{
public:
  PointNDOptions(int index) {_index=index;}
  PointNDOptions(const PointNDOptions& o) : CurvePointOptions() {_index=o._index;}

  void setIndex(int index) {_index=index;}
  int index() const {return _index;}

  double toDouble(const PointND& p) const {return p.y(_index);}
  void fromDouble(PointND& p, double v) const {p.setY(_index, v);}
private:
  int _index;
};

} // namespace QGpCoreMath

#endif // POINTNDOPTIONS_H
