/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2003-05-12
**  Copyright: 2003-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LINE2D_H
#define LINE2D_H

#include "Point2D.h"
#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT Line2D
  {
  public:
    inline Line2D(double c=0.0);
    inline Line2D(double b, double c);
    Line2D(const Point2D& p1, const Point2D& p2);
    Line2D(double x1, double y1, double az);
    inline Line2D(const Line2D& o);
    ~Line2D() {}

    Point2D intersect(const Line2D& o, bool& ok) const;
    void perpendicular(const Point2D& p);
    void parallel(const Point2D& p);
    bool isOnSameSide(const Point2D& p1, const Point2D& p2);

    double a() const {return _a;}
    double b() const {return _b;}
    double c() const {return _c;}

    double y(double x) const {return (_c-_a*x)/_b;}
    double x(double y) const {return (_c-_b*y)/_a;}
    Point2D direction() const;
  protected:
    double _a, _b, _c;
  };

  inline Line2D::Line2D(double c)
  {
    _a=1.0;
    _b=0.0;
    _c=c;
  }

  inline Line2D::Line2D(double a, double c)
  {
    _a=a;
    _b=1.0;
    _c=c;
  }

  inline Line2D::Line2D(const Line2D &o)
  {
    _a=o._a;
    _b=o._b;
    _c=o._c;
  }

} // namespace QGpCoreMath

#endif // LINE2D.H
