/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-08-31
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>

#include "ChiSquareTest.h"

namespace QGpCoreMath {

  /*!
    \class ChiSquareTest ChiSquareTest.h
    \brief Pearson's chi-square test

    Checks that a sample is consistant with a theoretical distribution.

    source: https://en.wikipedia.org/wiki/Pearson%27s_chi-squared_test
  */

  /*!
    Description of constructor still missing
  */
  ChiSquareTest::ChiSquareTest()
  {
    TRACE;
  }

  /*!
    Description of destructor still missing
  */
  ChiSquareTest::~ChiSquareTest()
  {
    TRACE;
  }

  /*!
    \a k is the degree of freedom
    source: https://en.wikipedia.org/wiki/Chi-square_distribution
  */
  double ChiSquareTest::probabilityDensity(double x, int k) const
  {
    ASSERT(k>0);
    ASSERT(x>0.0);
    double khalf=k*0.5;
    return 1.0/(pow(2.0, khalf)*tgamma(khalf))*pow(x, khalf-1.0)*exp(-x*0.5);
  }

  /*!
    \a k is the degree of freedom
    source: https://en.wikipedia.org/wiki/Chi-square_distribution

    Translated from Octave script for gammainc
  */
  double ChiSquareTest::cumulativeDistribution(double x, int k) const
  {
    ASSERT(k>0);
    ASSERT(x>0.0);
    //revise gamminc.m from Octave
  }


} // namespace QGpCoreMath

