/***************************************************************************
**
**  This file is part of QGpCompatibility.
**
**  QGpCompatibility is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCompatibility is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-10-21
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COMPATMODALFREQUENCY_H
#define COMPATMODALFREQUENCY_H

#include <QGpCoreTools.h>
#include "QGpCompatibilityDLLExport.h"

namespace QGpCompatibility {

class QGPCOMPATIBILITY_EXPORT CompatModalFrequency: public QVector<double>, public XMLClass
{
  TRANSLATIONS( "CompatModalFrequency" );
public:
  CompatModalFrequency();
  virtual ~CompatModalFrequency() {};

  virtual const QString& xml_tagName() const {return xmlModalFrequencyTag;}
  static const QString xmlModalFrequencyTag;

  void operator=(CompatModalFrequency& o);

  virtual void setNModes(int nm)=0;
  void setNRayleighModes(int nRm) {_nRayleighModes=nRm;}
  virtual void setNOmegas(int nf) {resize(nf);}

  virtual int nModes() const=0;
  int nRayleighModes() const {return _nRayleighModes;}
  int nLoveModes() const {return nModes()-_nRayleighModes;}
  int nOmegas() const {return count();}

  void insertOmegas(const CompatModalFrequency& samples);
  virtual void addRayleighModes(int nNewModes)=0;
  void addLoveModes(int nNewModes);

  double& omega(int iOmega) {return operator[] (iOmega);}
  const double& omega(int iOmega) const {return operator[] (iOmega);}

  void setFrequencies(QVector<double>& values);
  QVector<double> * frequencies() const;
  bool isSameOmegas(const CompatModalFrequency& o) const;
protected:
  int _nRayleighModes;
protected:
  virtual void insertInvalidAt(int i)=0;
  virtual void addInvalid()=0;

  virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
  virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
};

QGPCOMPATIBILITY_EXPORT QDataStream& operator<< (QDataStream& s, const CompatModalFrequency& p);
QGPCOMPATIBILITY_EXPORT QDataStream& operator>> (QDataStream& s, CompatModalFrequency& p);

} // namespace QGpCompatibility

#endif // COMPATMODALFREQUENCY_H
