/***************************************************************************
**
**  This file is part of HVGui.
**
**  HVGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-05-26
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "RotateResultSheet.h"
#include "RotateResultWidget.h"

namespace HVGui {

  /*!
    \class RotateResultSheet RotateResultSheet.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  RotateResultSheet::RotateResultSheet(QWidget * parent)
    : AbstractResultSheet(parent)
  {
    TRACE;
    _colorMap=new ColorMapWidget(0);
    _colorMap->setObjectName("SpectrumPalette");
    _colorMap->setNumberPrecision(2);
    _colorMap->setTitle(valueTitle());
    _colorMap->setAnchor(GraphicObject::TopCenter);
    _colorMap->setPrintXAnchor(5.0);
    _colorMap->setPrintYAnchor(1.0);
    _colorMap->setPrintWidth(8.0);
    _colorMap->setPrintHeight(1.5);
    _sheet.addObject(_colorMap);
  }

  /*!
    Description of destructor still missing
  */
  RotateResultSheet::~RotateResultSheet()
  {
    TRACE;
  }

  AbstractResultWidget * RotateResultSheet::createWidget()
  {
    TRACE;
    return new RotateResultWidget;
  }

  void RotateResultSheet::setStations(const QList<AbstractStation *>& stations)
  {
    TRACE;
    AbstractResultSheet::setStations(stations);
    if(_stations.isEmpty()) return;

    _colorMap->setColorMap(static_cast<RotateResultWidget *>(_results.first())->gridLayer()->colorMap());

    int n=_results.count();
    for(int i=0; i<n; i++) {
      IrregularGrid2DPlot * plot =static_cast<RotateResultWidget *>(_results.at(i))->gridLayer();
      plot->setColorMap(_colorMap->colorMap());
      connect(plot, SIGNAL(colorMapChanged(ColorMap)), _colorMap, SLOT(setColorMap(const ColorMap&)));
      connect(_colorMap, SIGNAL(changed(ColorMap)), plot, SLOT(setColorMap(const ColorMap&)));
    }
  }

  void RotateResultSheet::setLimits(double maxAmplitude)
  {
    TRACE;
    const RotateResults * res=static_cast<const RotateResults *>(firstValidResult());
    if(res) {
      const SamplingParameters& r=res->frequencySampling();
      for(QList<AbstractResultWidget *>::iterator it=_results.begin(); it!=_results.end(); it++) {
        static_cast<RotateResultWidget *>(*it)->setLimits(r);
      }
    }
    _colorMap->setValues(0.0, maxAmplitude, SamplingParameters::Linear);
  }

  void RotateResultSheet::setLayout(int nPlotsPerLine, double pageHeight)
  {
    TRACE;
    AbstractResultSheet::setLayout(nPlotsPerLine, pageHeight);
    // Make sure that color map is not itself far away from plot results
    _colorMap->setPrintLeft(1.0);
    _colorMap->setPrintTop(1.0);
    // Effectively move the color map to the correct position
    _colorMap->setPrintXAnchor(_sheet.printRight()*0.5);
    _colorMap->setPrintYAnchor(_sheet.printBottom());
    _colorMap->updateGeometry();
  }

  void RotateResultSheet::setValueTitle(const QString& t)
  {
    TRACE;
    AbstractResultSheet::setValueTitle(t);
    _colorMap->setTitle(valueTitle());
  }

} // namespace HVGui

