/***************************************************************************
**
**  This file is part of HVGui.
**
**  HVGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-10-10
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "LoadWinStatList.h"

namespace HVGui {

  /*
   *  Constructs a LoadWinStatList as a child of 'parent', with the
   *  name 'name' and widget flags set to 'f'.
   *
   *  The dialog will by default be modeless, unless you set 'modal' to
   *  true to construct a modal dialog.
   */
  LoadWinStatList::LoadWinStatList(QWidget *parent, Qt::WindowFlags f)
      : Dialog(parent, f)
  {
    TRACE;
    setupUi(this);


    // signals and slots connections
    connect(buttonOk, SIGNAL(clicked()), this, SLOT(accept()) );
    connect(buttonCancel, SIGNAL(clicked()), this, SLOT(reject()) );
  }

  void LoadWinStatList::setStationsList(QList<AbstractStation *> lists)
  {
    TRACE;
    statList->clear();
    for(QList<AbstractStation *>::iterator it=lists.begin(); it!=lists.end();++it) {
      statList->addItem((*it)->name());
    }
  }

  void LoadWinStatList::getSelectedStations(QList<AbstractStation *> lists, QList<AbstractStation *>& selList)
  {
    TRACE;
    for(int i=0; i<lists.count();++i) {
      if(statList->item(i)->isSelected()) selList.append(lists.at(i));
    }
  }

} // namespace HVGui
