/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-07-12
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <GeopsyCore.h>
#include "StationCoordinatesItem.h"

namespace GeopsyGui {

/*!
  \class StationCoordinatesItem StationCoordinatesItem.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
StationCoordinatesItem::StationCoordinatesItem(QObject * parent)
    : QAbstractItemModel(parent)
{
  TRACE;
  _stationSignalsList=0;
  _stationList=0;
}

void StationCoordinatesItem::setStations(QList<NamedPoint> * s)
{
  _stationList=s;
}

void StationCoordinatesItem::setStations(StationList * s)
{
  _stationSignalsList=s;
}

int StationCoordinatesItem::rowCount(const QModelIndex &parent) const
{
  TRACE;
  if( !parent.isValid()) {
    if(_stationList)
      return _stationList->count();
    else if(_stationSignalsList)
      return _stationSignalsList->count();
  }
  return 0;
}

int StationCoordinatesItem::columnCount(const QModelIndex & ) const
{
  TRACE;
  return 4;
}

QVariant StationCoordinatesItem::data(const QModelIndex &index, int role) const
{
  TRACE;
  if(_stationList) {
    const NamedPoint& s=_stationList->at(index.row());
    switch (role) {
    case Qt::DisplayRole:
    case Qt::EditRole:
      switch (index.column()) {
      case 0: return s.name();
      case 1: return QString::number(s.x(), 'f', 2);
      case 2: return QString::number(s.y(), 'f', 2);
      case 3: return QString::number(s.z(), 'f', 2);
      default: break;
      }
    default:
      break;
    }
  } else if(_stationSignalsList) {
    const StationSignals * stat=_stationSignalsList->at(index.row());;
    switch (role) {
    case Qt::DisplayRole:
    case Qt::EditRole:
      switch (index.column()) {
      case 0: return stat->name();
      case 1: return QString::number(stat->coordinates().x(), 'f', 2);
      case 2: return QString::number(stat->coordinates().y(), 'f', 2);
      case 3: return QString::number(stat->coordinates().z(), 'f', 2);
      default: break;
      }
    default:
      break;
    }
  }
  return QVariant();
}

bool StationCoordinatesItem::setData (const QModelIndex & index, const QVariant & value, int role)
{
  TRACE;
  if(_stationList) {
    NamedPoint& s=(*_stationList)[index.row()];
    switch (role) {
    case Qt::EditRole:
      switch (index.column()) {
      case 0:
        s.setName(value.toString());
        emit dataChanged(index, index);
        return true;
      case 1:
        s.setX(value.toDouble());
        emit dataChanged(index, index);
        return true;
      case 2:
        s.setY(value.toDouble());
        emit dataChanged(index, index);
        return true;
      case 3:
        s.setZ(value.toDouble());
        emit dataChanged(index, index);
        return true;
      default:
        break;
      }
    default:
      break;
    }
  }
  return false;
}

QVariant StationCoordinatesItem::headerData(int section, Qt::Orientation orientation, int role) const
{
  TRACE;
  if(role!=Qt::DisplayRole) return QVariant();
  if(orientation==Qt::Horizontal) {
    switch (section) {
    case 0: return tr( "Name" );
    case 1: return tr( "X" );
    case 2: return tr( "Y" );
    case 3: return tr( "Z" );
    default: return QVariant();
    }
  } else {
    return section + 1;
  }
}

QModelIndex StationCoordinatesItem::index (int row, int column, const QModelIndex & ) const
{
  TRACE;
  return createIndex(row, column);
}

} // namespace GeopsyGui
