/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-02-28
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SIGNALLAYERCONTROLS_H
#define SIGNALLAYERCONTROLS_H

#include "SignalLayer.h"
#include "ui_SignalLayerControls.h"

namespace GeopsyGui {

  class GEOPSYGUI_EXPORT SignalLayerControls : public QWidget, private Ui::SignalLayerControls
  {
    Q_OBJECT
  public:
    SignalLayerControls(SignalLayer * signalLayer, QWidget * parent=nullptr);
    ~SignalLayerControls();
  private slots:
    void propertiesChanged();
    void on_timeSlider_sliderPressed();
    void on_timeSlider_sliderMoved(int value);
    void on_timeSlider_sliderReleased();
    void on_amplitudeSlider_sliderPressed();
    void on_amplitudeSlider_sliderMoved(int value);
    void on_amplitudeSlider_sliderReleased();
    void on_normalizationCombo_currentIndexChanged(int index);
    void on_offsetCombo_currentIndexChanged(int index);
  private:
    void updateSignals();

    SignalLayer * _signalLayer;
    double _referenceOverlap, _referenceTimeRange;
  };

} // namespace GeopsyGui

#endif // SIGNALLAYERCONTROLS_H
