/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-04-21
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PICKLAYER_H
#define PICKLAYER_H

#include <GeopsyCore.h>
#include <SciFigs.h>
#include "PickFormat.h"
#include "GeopsyGuiDLLExport.h"

namespace GeopsyGui {

class SignalLayer;

class GEOPSYGUI_EXPORT PickLayer : public GraphContentLayer
{
  Q_OBJECT
public:
  PickLayer(AxisWindow * parent=nullptr);
  PickLayer(SignalLayer * sig);
  ~PickLayer();

  virtual const QString& xml_tagName() const {return xmlPickLayerTag;}
  static const QString xmlPickLayerTag;

  virtual Rect boundingRect() const;

  virtual bool hasProperties() {return true;}
  virtual void addProperties(PropertyProxy * pp);
  virtual void removeProperties(PropertyProxy * pp);
  virtual void properties(PropertyWidget * w) const;
  virtual void setProperty(uint wid, int pid, QVariant val);

  void setFreePickNames(bool fpn) {_freePickNames=fpn;}
  bool freePickNames() const {return _freePickNames;}

  PickFormat& format() {return _format;}
  const PickFormat& format() const {return _format;}

  enum TrackingModes{Pick, DeletePicks};
  virtual void toggleTrackingAction(bool checked, int id=-1);
  virtual bool trackRectangle(int id, double rx1, double ry1, double rx2, double ry2, Qt::KeyboardModifiers);

  virtual bool mousePressEvent (QMouseEvent * e, int);
  virtual bool mouseReleaseEvent (QMouseEvent * e, int);
  virtual void mouseMoveEvent (const QPoint& pt, Qt::MouseButtons, Qt::KeyboardModifiers);
  virtual bool keyPressEvent (QKeyEvent * e);
public slots:
  virtual bool setPick(const QString& pickName=QString());
signals:
  void mouseMoved(double t);
  void pickBegin(bool magnify, int context, double time, Signal * sig, int iSig);
  void pickChanged(Signal * sig, QString pickName);
  void pickEnd();
  void currentSignalChanged(Signal * sig, int iSig);
protected:
  void initMembers();
  virtual void paintData(const LayerPainterRequest& lp, QPainter& p, double dotpercm) const;
  virtual void paintText(const LayerPainterRequest& lp, double dotpercm);
  virtual bool eventFilter(QObject *obj, QEvent *event);

  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);

  SignalLayer * _sig;

  bool _freePickNames;
  // Currently modified signals, -1 if no pick is being modified
  int _iSigPick;
  // Currently modified pick
  QString _pickName;

  PickFormat _format;
  static uint _tab;
private:
  QList<QPainterPath> _textPaths;
  mutable Mutex _textPathsMutex;
};

} // namespace GeopsyGui

#endif // PICKLAYER_H
