/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-06-10
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <GeopsyCore.h>

#include "PickFormat.h"

namespace GeopsyGui {

  /*!
    \class PickFormat PickFormat.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  const QString PickFormat::xmlPickFormatTag="PickFormat";

  /*!
    \fn PickFormat::PickFormat()
    Description of constructor still missing
  */

  /*!
    Copy constructor
  */
  PickFormat::PickFormat(const PickFormat& o)
    : XMLClass()
  {
    TRACE;
    _formats=o._formats;
  }

  bool PickFormat::isVisible(const QString& pickName) const
  {
    TRACE;
    QMap<QString, Format>::const_iterator it=_formats.find(pickName);
    if(it!=_formats.end()) {
      return it.value().visible;
    } else {
      return false;
    }
  }

  QColor PickFormat::color(const QString& pickName) const
  {
    TRACE;
    QMap<QString, Format>::const_iterator it=_formats.find(pickName);
    if(it!=_formats.end()) {
      return it.value().color;
    } else {
      return Qt::blue;
    }
  }

  void PickFormat::setVisible(const QString& pickName, bool v)
  {
    TRACE;
    _formats[pickName].visible=v;
  }

  void PickFormat::setColor(const QString& pickName, const QColor& c)
  {
    TRACE;
    _formats[pickName].color=c;
  }

  static const QString keys[]={"visible", "color"};

  void PickFormat::xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const
  {
    TRACE;
    Q_UNUSED(context)
    XMLSaveAttributes att;
    QString& visible=att.add(keys[0]);
    QString& color=att.add(keys[1]);
    for(QMap<QString, Format>::const_iterator it=_formats.begin(); it!=_formats.end(); it++) {
      visible=it.value().visible ? "true" : "false";
      color=it.value().color.name();
      writeProperty(s, "timePick", att, it.key());
    }
  }

  XMLMember PickFormat::xml_member(XML_MEMBER_ARGS)
  {
    TRACE;
    Q_UNUSED(attributes)
    Q_UNUSED(context)
    if(tag=="timePick") return XMLMember(0);
    return XMLMember(XMLMember::Unknown);
  }

  bool PickFormat::xml_setProperty(XML_SETPROPERTY_ARGS)
  {
    TRACE;
    Q_UNUSED(tag)
    Q_UNUSED(context)
    if(memberID!=0) return false;
    QString name=content.toString();
    Format& format=_formats[name];
    XMLRestoreAttributeIterator it;
    it=attributes.find(keys[0]);
    if(it!=attributes.end()) {
      format.visible=(it.value()=="true");
    } else {
      format.visible=false;
    }
    it=attributes.find(keys[1]);
    if(it!=attributes.end()) {
      format.color.setNamedColor(it.value().toString());
    } else {
      format.color=Qt::blue;
    }
    return true;
  }

} // namespace GeopsyGui
