/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-10-20
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ASCIISIGNALRULESWIDGET_H
#define ASCIISIGNALRULESWIDGET_H

#include <QtGui>
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
#include <QtWidgets>
#endif

#include <GeopsyCore.h>

#include "ui_AsciiSignalRulesWidget.h"

namespace GeopsyGui {

  class AsciiSignalRulesWidget : public QWidget, private Ui::AsciiSignalRulesWidget
  {
    Q_OBJECT
  public:
    AsciiSignalRulesWidget(QWidget * parent=0, Qt::WindowFlags f=Qt::Widget);
    ~AsciiSignalRulesWidget();

    void setFormat(AsciiSignalFormat * f);
    void setHeader(const QString& h);
    void setExampleErrors(AbstractStream * s);
  private slots:
    void on_addButton_clicked();
    void on_removeButton_clicked();
    void on_downButton_clicked();
    void on_upButton_clicked();
  };

  class AsciiSignalRulesItem : public QAbstractTableModel
  {
  public:
    AsciiSignalRulesItem(QObject * parent) : QAbstractTableModel(parent) {_format=0;}

    void setFormat(AsciiSignalFormat * f);
    void setHeader(const QString& h);
    void setExampleErrors(AbstractStream * s) {_exampleErrors=s;}

    virtual int rowCount(const QModelIndex &) const {return _format ? _format->ruleCount() : 0;}
    virtual int columnCount(const QModelIndex &) const {return 10;}
    virtual QVariant data(const QModelIndex & index, int role=Qt::DisplayRole) const;
    virtual QVariant headerData(int section, Qt::Orientation orientation, int role=Qt::DisplayRole) const;
    virtual bool setData (const QModelIndex & index, const QVariant & value, int role=Qt::EditRole);
    virtual bool insertRow(int row);
    virtual bool removeRow(int row);
    bool moveUp(int row);
    bool moveDown(int row);
    virtual Qt::ItemFlags flags (const QModelIndex & index) const;
  private:
    void updateValue(const QModelIndex & index);

    AsciiSignalFormat * _format;
    QString _header;
    AbstractStream * _exampleErrors;
  };

  class AsciiSignalRulesDelegate : public QItemDelegate
  {
    Q_OBJECT
  public:
    AsciiSignalRulesDelegate(QObject *parent=0);

    QWidget *createEditor(QWidget *parent, const QStyleOptionViewItem &option,
                          const QModelIndex &index) const;
    void setEditorData(QWidget *editor, const QModelIndex &index) const;
    void setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index) const;
  private slots:
    void commitWidget(QWidget * w=0);
  private:
    QStringList _tableFieldList;
  };

} // namespace GeopsyGui

#endif // ASCIISIGNALRULESWIDGET_H
