/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-04-19
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TIMERANGEPARAMETERS_H
#define TIMERANGEPARAMETERS_H

#include <QGpCoreTools.h>

#include "GeopsyCoreDLLExport.h"
#include "TimeRange.h"

namespace GeopsyCore {

  class Signal;
  class SubSignalPool;
  class StationSignals;

  class GEOPSYCORE_EXPORT TimeRangeParameters : public TimeRange,
      public AbstractParameters, public XMLClass
  {
    TRANSLATIONS("TimeRangeParameters")
  public:
    TimeRangeParameters();
    TimeRangeParameters(const TimeRangeParameters& o);

    virtual AbstractParameters * clone() const {return new TimeRangeParameters(*this);}

    enum Type {Absolute, Delta, Signal, Pick};

    void setStartType(Type t) {_startType=t;}
    void setStartType(const QString& t) {_startType=string2Type(t);}
    Type startType() const {return _startType;}
    QString startTypeString() const {return type2String(_startType);}

    void setEndType(Type t) {_endType=t;}
    void setEndType(const QString& t) {_endType=string2Type(t);}
    Type endType() const {return _endType;}
    QString endTypeString() const {return type2String(_endType);}

    const QString& startPick() const {return _startPick;}
    void setStartPick(const QString& p) {_startPick=p;}

    const QString& endPick() const {return _endPick;}
    void setEndPick(const QString& p) {_endPick=p;}

    double deltaT() const {return _deltaT;}
    void setDeltaT(double dt) {_deltaT=dt;}

    const QString& reference() const {return _reference;}
    void setReference(const QString& ref) {_reference=ref;}

    TimeRange absoluteRange(const GeopsyCore::Signal * sig) const;
    TimeRange absoluteRange(const SubSignalPool * subPool) const;
    TimeRange absoluteRange(const StationSignals * sigs) const;

    QString toShortString() const;
    void fromShortString(QString s);

    virtual void xml_attributes(XML_ATTRIBUTES_ARGS) const;
    virtual bool xml_setAttributes(XML_SETATTRIBUTES_ARGS);

    virtual const QString& xml_tagName() const {return xmlTimeRangeParametersTag;}
    static const QString xmlTimeRangeParametersTag;

    virtual QString toString(PARAMETERS_TOSTRING_ARGS_DECL) const;
    virtual void collectKeywords(PARAMETERS_COLLECTKEYWORDS_ARGS);
  protected:
    virtual int keywordCount(PARAMETERS_KEYWORDCOUNT_ARGS) const;
    virtual bool setValue(PARAMETERS_SETVALUE_ARGS);
  private:
    static QString type2String(Type t);
    static Type string2Type(QString t);

    DateTime absoluteStart(const GeopsyCore::Signal * sig) const;
    DateTime absoluteEnd(const GeopsyCore::Signal * sig) const;
    DateTime absoluteStart(const SubSignalPool * subPool) const;
    DateTime absoluteEnd(const SubSignalPool * subPool) const;

    QString _startPick,_endPick, _reference;
    double _deltaT;
    Type _startType;
    Type _endType;
  };

} // namespace GeopsyCore

// Allow passing TimeRangeParameters as a QVariant
Q_DECLARE_METATYPE(GeopsyCore::TimeRangeParameters)

#endif // TIMERANGEPARAMETERS_H
