/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-07-28
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "SortKey.h"

namespace GeopsyCore {

  /*!
    \class SortKey SortKey.h
    \brief A key to sort SubSignalPool

    Sorting signals according to several keys (based on meta data) is not thread safe.
    It is based on a static list of keys interpreted by lessThan().
  */

  QList<SortKey> SortKey::_keys;

  /*!
    \fn SortKey(const MetaDataIndex& d, bool r)
    Initialize a sort key from a meta data index \a d. \r is true for reserved order.
  */

  /*!
    \fn SortKey(int id, bool r=false)
    Overload for convenience, \a id is usually a standard meta data id.
  */

  /*!
    \fn SortKey(const SortKey& o)
    Copy constructor.
  */

  /*!
    \fn bool reversed()
    Returns true for reserved order.
  */

  /*!
    \fn bool lessThan(const Signal * sig1, const Signal * sig2)
    Function for comparing two signals according to the current list of sort keys. Usually passed to
    std::sort().

    \sa SubSignalPool::sort()
  */

  /*!
    \fn void clear()
    Clears the current list of sort keys.
  */

  /*!
    \fn void add(const SortKey& k)
    Add \a k to the current list of sort keys.
  */

  /*!
    \fn int count()
    Returns the number of sort keys in the current list.
  */

  /*!
    \fn const SortKey& sortKey(int index)
    Returns key at \a index in the current list.
  */

} // namespace GeopsyCore
