/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-08-02
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef METADATAMAP_H
#define METADATAMAP_H

#include <QGpCoreTools.h>

#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

  class MetaData;

  class GEOPSYCORE_EXPORT MetaDataMap : private SortedVector<int, MetaData>
  {
  public:
    ~MetaDataMap();

    void operator=(const MetaDataMap& o);

    int count() const {return SortedVector<int, MetaData>::count();}
    void clear();
    void reserve(int size) {SortedVector<int, MetaData>::reserve(size);}

    void add(MetaData * d);
    void remove(int id);
    bool hasData(int id) const {return firstIndexOf(id)>-1;}
    MetaData * data(int id);
    const MetaData * data(int id) const;
    const SortedVector<int, MetaData>& vector() const {return *this;}
  private:
    friend class SignalDatabase;
    void add(const MetaDataMap& o);
  };

} // namespace GeopsyCore

#endif // METADATAMAP_H
