/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-12-12
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "KeepSignal.h"
#include "TimeRange.h"
#include "GeoSignal.h"

namespace GeopsyCore {

/*!
  \class KeepSignal KeepSignal.h
  \brief Integer vector that tells if samples are acceptable for processing

  keep may take three distinct values:
  \li -1 the sample will never be accepted (e.g. when the signal does not exist)
  \li 0  the sample is bad but may eventually be tolerated (e.g. tests not passed)
  \li 1  the sample is good and it is always accepted

*/

/*!
  Description of constructor still missing
*/
KeepSignal::KeepSignal()
    : SignalTemplate<int>()
{
  TRACE;
  _samplingPeriod=0.0;
}

KeepSignal::KeepSignal(int n)
    : SignalTemplate<int>(n)
{
  TRACE;
  _samplingPeriod=0.0;
}

KeepSignal::KeepSignal(const KeepSignal& o) :
    SignalTemplate<int>(o)
{
  TRACE;
  _samplingPeriod=o._samplingPeriod;
  _startTime=o._startTime;
}

void KeepSignal::debugPrint() const
{
  TRACE;
  printf( "Debug samples for signal %s\n", debugName().toLatin1().data());
  CONST_LOCK_SAMPLES(int, thisSamples, this)
    for(int i=0;i < _nSamples;i++ ) printf( "%i\t%i\n", i, thisSamples[ i ] );
  UNLOCK_SAMPLES(this)
}

} // namespace GeopsyCore
