/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2017-09-18
**  Copyright: 2017-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef CORETOOLINTERFACE_H
#define CORETOOLINTERFACE_H

#include "SubSignalPool.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

  class GEOPSYCORE_EXPORT CoreToolInterface
  {
  public:
    CoreToolInterface();
    ~CoreToolInterface();

    void setParameters(AbstractParameters * param);
    bool setOptions(int& argc, char ** argv);
    static void setHelp(ApplicationHelp * h);

    int subPoolCount() const;
    SubSignalPool subPool(int index) const;
    QString groupName(int index) const;

    const QStringList& stationList() const {return _stationList;}
    AbstractParameters * parameters() const {return _param;}

    void setOutputBaseName(const QString& f) {_outputBaseName=f;}
    const QString& outputBaseName() const {return _outputBaseName;}
  private:
    bool fixDatabasePaths(QString databaseFileName);

    AbstractParameters * _param;
    QList<const AbstractSignalGroup *> _groups;
    QString _outputBaseName;
    QStringList _stationList;
  };

} // namespace GeopsyCore

#endif // CORETOOLINTERFACE_H

