/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-12-11
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "CompatibilityTimeReference.h"
#include "MetaDataFactory.h"

namespace GeopsyCore {

  /*!
    \class CompatibilityTimeReference CompatibilityTimeReference.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  REGISTER_METADATA(CompatibilityTimeReference)

  bool CompatibilityTimeReference::operator==(const MetaData& o) const
  {
    const CompatibilityTimeReference& v=reinterpret_cast<const CompatibilityTimeReference&>(o);
    return _timeReference==v._timeReference && _t0==v._t0;
  }

  void CompatibilityTimeReference::operator=(const MetaData& o)
  {
    const CompatibilityTimeReference& v=reinterpret_cast<const CompatibilityTimeReference&>(o);
    _timeReference=v._timeReference;
    _t0=v._t0;
  }

  DateTime CompatibilityTimeReference::startTime() const
  {
    return _timeReference.shifted(_t0);
  }

  QStringList CompatibilityTimeReference::subNames() const
  {
    QStringList names;
    names << xmlCompatibilityTimeReferenceTag;
    return names;
  }

  QString CompatibilityTimeReference::name(int, const QString&) const
  {
    return xmlCompatibilityTimeReferenceTag;
  }

  QString CompatibilityTimeReference::baseName(int) const
  {
    return xmlCompatibilityTimeReferenceTag;
  }

  QString CompatibilityTimeReference::title(int, const QString&) const
  {
    return tr("Obsolete TimeReference");
  }

} // namespace GeopsyCore

