/***************************************************************************
**
**  This file is part of DinverDCCore.
**
**  DinverDCCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverDCCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-02-18
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "DispersionTarget.h"

namespace DinverDCCore {

  /*!
    \class DispersionTarget DispersionTarget.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  const QString DispersionTarget::xmlDispersionTargetTag="DispersionTarget";

  /*!
    Description of constructor still missing
  */
  DispersionTarget::DispersionTarget()
    : ModalCurveTarget()
  {
    TRACE;
    // From 20190218, stddev of dispersion curve is computed on a log scale
    setMisfitType(L2_LogNormalized);
  }

  bool DispersionTarget::xml_polish(XML_POLISH_ARGS)
  {
    Q_UNUSED(context)
    if(misfitType()==L2_Normalized) { // Kept for compatibity
      // Convert stddev in slowness to log
      for(QList<ModalCurve>::iterator it=curves().begin(); it!=curves().end(); ++it) {
        ModalCurve& c=*it;
        for(int i=c.count()-1; i>=0; i--) {
          FactoryPoint& p=c.constXAt(i);
          p.setStddev(0.5*((p.mean()+p.stddev())/p.mean()+p.mean()/(p.mean()-p.stddev())));
        }
      }
     }
    // Force L2_LogNormalized and ignore value read from file
    setMisfitType(L2_LogNormalized);
    return true;
  }

} // namespace DinverDCCore

