/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-06-06
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef XMLDINVERCONTEXT_H
#define XMLDINVERCONTEXT_H

#include <QGpCoreTools.h>
#include "DinverCoreDLLExport.h"

namespace DinverCore {

class DINVERCORE_EXPORT XMLDinverContext : public XMLContext
{
public:
  enum FileType{Targets=1, Parameters=2,  All=3};

  XMLDinverContext(FileType ft) {_fileType=ft;}
  ~XMLDinverContext() {}

  bool all() const {return targets() && parameters();}
  bool targets() const {return _fileType & Targets;}
  bool parameters() const {return _fileType & Parameters;}
private:
  FileType _fileType;
};

} // namespace DinverCore

#endif // XMLDINVERCONTEXT_H
