/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-12-22
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PARENTINDEX_H
#define PARENTINDEX_H

#include "GeneratorModels.h"
#include "DinverCoreDLLExport.h"

namespace DinverCore {

  class DINVERCORE_EXPORT ParentIndex
  {
  public:
    inline ParentIndex(GeneratorModels * models, const ActiveIndex& index);
    inline ParentIndex(const ParentIndex& o);
    inline ~ParentIndex();

    int serialNumber() const {return _models->serialNumber();}
    const ActiveModels * activeModels() const {return _models->activeModels();}
    const ScaledModels * scaledModels() const {return _models->scaledModels();}
    const ActiveIndex& index() const {return _index;}
  private:
    GeneratorModels * _models;
    ActiveIndex _index;
  };

  inline ParentIndex::ParentIndex(GeneratorModels * models, const ActiveIndex& index)
  {
    _models=models;
    _models->addReference();
    _index=index;
  }

  inline ParentIndex::ParentIndex(const ParentIndex& o)
  {
    _models=o._models;
    _models->addReference();
    _index=o._index;
  }

  inline ParentIndex::~ParentIndex()
  {
    GeneratorModels::removeReference(_models);
  }

} // namespace DinverCore

#endif // PARENTINDEX_H
