/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-05-06
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ABSTRACTFORWARD_H
#define ABSTRACTFORWARD_H

#include <QGpCoreMath.h>

#include "DinverCoreDLLExport.h"
#include "RealSpace.h"

namespace DinverCore {

class ReportWriter;

class DINVERCORE_EXPORT AbstractForward
{
  TRANSLATIONS("AbstractForward")
public:
  AbstractForward() {}
  virtual ~AbstractForward() {}

  virtual AbstractForward * clone() const=0;

  const RealSpace& parameterSpace() const {return _parameterSpace;}
  RealSpace& parameterSpace() {return _parameterSpace;}

  virtual double misfit(bool& ok);
  virtual double misfit(double * /*model*/ , bool& /*ok*/ ) {return 1.0;}
  virtual void writeReport(ReportWriter * /*report*/ ) {}
  virtual void valueChanged(const Parameter * p=nullptr) {Q_UNUSED(p)}
  virtual bool isFussyOk(const Parameter * /*p*/ ) {return true;}
  virtual int maximumThreadCount() const {return 1;}

  bool firstModel(Random& randomNumbers, AtomicBoolean& terminated);
  void copyValues(const AbstractForward& o);

  // Public XML interface... this object is not an XMLClass
  virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const {Q_UNUSED(s) Q_UNUSED(context)}
  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const {Q_UNUSED(s) Q_UNUSED(context)}
  virtual XMLMember xml_member(XML_MEMBER_ARGS) {Q_UNUSED(tag) Q_UNUSED(attributes) Q_UNUSED(context) return XMLMember(XMLMember::Skip);}
  virtual bool xml_setProperty(XML_SETPROPERTY_ARGS) {Q_UNUSED(memberID) Q_UNUSED(tag) Q_UNUSED(attributes) Q_UNUSED(content) Q_UNUSED(context) return true;}
  virtual bool xml_polish(XML_POLISH_ARGS) {Q_UNUSED(context) return true;}
private:
  RealSpace _parameterSpace;
};

} // namespace DinverCore

#endif // ABSTRACTFORWARD_H
