/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-02-01
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SINGLEDIRECTRAYLEIGH_H
#define SINGLEDIRECTRAYLEIGH_H

#include "HRFKDirectRayleigh.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT SingleDirectRayleigh : public HRFKDirectRayleigh
  {
  public:
    SingleDirectRayleigh(FKCache * gridCache);

    void addCrossSpectrum();
    void meanCrossSpectrum(int);

    void setGrid(FKGridSearch * g, double, double);

    double value(const Point&, int index) const;
    double value(const Point&) const;

    bool hasEllipticity() const {return false;}
    double ellipticity(const Point& gridPoint, bool& ok);

    bool isOnLimit(const Point&, double) const {return false;}
  };

} // namespace ArrayCore

#endif // SINGLEDIRECTRAYLEIGH_H

