/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-02-01
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "SingleDirectRayleigh.h"
#include "FKGridSearch.h"
#include "FKCrossSpectrum.h"
#include "FKSteeringThreeComponentRayleighRadial.h"

namespace ArrayCore {

  /*!
    \class SingleDirectRayleigh SingleDirectRayleigh.h
    \brief Brief description of class still missing

    Single station processing to extract ellipticity.
  */

  /*!
    Description of constructor still missing
  */
  SingleDirectRayleigh::SingleDirectRayleigh(FKCache * gridCache)
    : HRFKDirectRayleigh(gridCache)
  {
    TRACE;
  }


  void SingleDirectRayleigh::addCrossSpectrum()
  {
    _crossSpectrum->addRayleighSingle();
  }

  void SingleDirectRayleigh::meanCrossSpectrum(int)
  {
    _crossSpectrum->meanRayleighSingle();
  }

  void SingleDirectRayleigh::setGrid(FKGridSearch * g, double, double)
  {
    g->setGrid(0.0, 2.0, 1.0); // 3 points to get one maximum at index 1
  }

  double SingleDirectRayleigh::value(const Point&, int index) const
  {
    return index==1 ? 1.0 : 0.0;
  }

  double SingleDirectRayleigh::value(const Point&) const
  {
    return 0.0;
  }

  double SingleDirectRayleigh::ellipticity(const Point&, bool&)
  {
    return _crossSpectrum->matrix().at(2, 2).re();
    //return _crossSpectrum->matrix().at(1, 2).re();
  }

} // namespace ArrayCore

