/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-12-10
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "SPACTaskManager.h"
#include "SPACWorker.h"
#include "SPACResults.h"

namespace ArrayCore {

  /*!
    \class SPACTaskManager SPACTaskManager.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  SPACTaskManager::SPACTaskManager(const ArraySelection * array)
    : ArrayTaskManager(array)
  {
    TRACE;
  }

  /*!
    Description of destructor still missing
  */
  SPACTaskManager::~SPACTaskManager()
  {
    TRACE;
  }

  bool SPACTaskManager::setParameters(const ArrayParameters * param)
  {
    TRACE;
    const SPACParameters * spacParam=dynamic_cast<const SPACParameters *>(param);
    if(!spacParam) {
      qDebug() << "Parameters are not SPACParameters in SPACTaskManager::setParameters.";
      return false;
    }
    if(!ArrayTaskManager::setParameters(param)) {
      return false;
    }
    SPACResults * spacResults=static_cast<SPACResults *>(results());
    spacResults->setParameters(*spacParam);

    return true;
  }

  LoopWorker * SPACTaskManager::newWorker()
  {
    TRACE;
    SPACWorker * w=new SPACWorker(&_array, parameters());
    w->setTaskManager(this);
    return w;
  }

} // namespace ArrayCore

