/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-01-04
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "PoggiFKRadial.h"
#include "HRFKVertical.h"

namespace ArrayCore {

  /*!
    \class PoggiFKRadial PoggiFKRadial.h
    \brief Radial high resolution FK power with ellipticity

    Radial high resolution FK power versus wavenumber (k) function.
    The cross-spectrum is already projected on the radial direction.
    Ellipticity is computed according Poggi et al. (2010) in GJI.
  */

  double PoggiFKRadial::ellipticity(const Point& k, bool& ok)
  {
    HRFKVertical vertical(_gridCache);
    ok=true;
    return ::sqrt(value(k)/vertical.value(k));
  }

} // namespace ArrayCore

