/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-07-21
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef HRFKDIRECTRAYLEIGHFIXEDELL_H
#define HRFKDIRECTRAYLEIGHFIXEDELL_H

#include "HRFKDirectRayleigh.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT HRFKDirectRayleighFixedEll : public HRFKDirectRayleigh
  {
  public:
    HRFKDirectRayleighFixedEll(FKCache * gridCache)
      : HRFKDirectRayleigh(gridCache) {_ellipticity=0.0;}

    virtual bool setFixedEllipticity(double frequency);
    void setEllipticity(double ell);

    virtual void setGrid(FKGridSearch * g, double step, double size);
    virtual bool initGrid(int n);
    virtual void initGrid(const Point& k, int index);

    virtual double value(const Point& k, int index) const;
    virtual double value(const Point& k) const;

    virtual double ellipticity(const Point&, bool& ok) {ok=true; return _ellipticity;}

    bool loadFixedEllipticityCurve(const QString& fileName);
  private:
    double _ellipticity;

    Curve<Point2D> _fixedEllipticities;
  };

} // namespace ArrayCore

#endif // HRFKDIRECTRAYLEIGHFIXEDELL_H

