/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-04-12
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "FKSteeringThreeComponentRayleighVertical.h"

namespace ArrayCore {

  const int FKSteeringThreeComponentRayleighVertical::sizeFactor=3;

  /*!
    \class FKSteeringThreeComponentRayleighVertical FKSteeringThreeComponentRayleighVertical.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  void FKSteeringThreeComponentRayleighVertical::init(FKCache * cache, int index, const Point& kell)
  {
    FKSteeringThreeComponentRayleighVertical& s=FKSteeringThreeComponentRayleighVertical::cache(cache, index);
    s.resize();
    s.initValue(kell, ::tan(kell.z()));
  }

  void FKSteeringThreeComponentRayleighVertical::initValue(const Point2D& k, double ell)
  {
    int stationCount=_array->count();
    int stationCount2=2*stationCount;
    Complex q, qc;
    Complex cell(0.0, 1.0/ell);
    Angle rotation(k.x(), k.y());
    for(int i=stationCount-1; i>=0; i--) {
      const Point2D& r=_array->relativePos(i);
      q.setUnitExp(-r.scalarProduct(k));
      qc=conjugate(q);
      _e.at(i, 0)=q*rotation.cos();
      _eh.at(0, i)=qc*rotation.cos();
      _e.at(i+stationCount, 0)=q*rotation.sin();
      _eh.at(0, i+stationCount)=qc*rotation.sin();
      q*=cell;
      _e.at(i+stationCount2, 0)=q;
      _eh.at(0, i+stationCount2)=conjugate(q);
    }
  }

} // namespace ArrayCore

