/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-04-12
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "FKSteeringThreeComponentRayleighRadial.h"

namespace ArrayCore {

  const int FKSteeringThreeComponentRayleighRadial::sizeFactor=3;

  /*!
    \class FKSteeringThreeComponentRayleighRadial FKSteeringThreeComponentRayleighRadial.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  void FKSteeringThreeComponentRayleighRadial::resize()
  {
    int n=sizeFactor*_array->count();
    FKSteering::resize(n);
    /*_t.resize(n, 1);
    _th.resize(1, n);
    _u.resize(n, 1);
    _uh.resize(1, n);
    _thrx.resize(1, n);
    _thry.resize(1, n);
    _uhrx.resize(1, n);
    _uhry.resize(1, n);*/
  }

  void FKSteeringThreeComponentRayleighRadial::init(FKCache * cache, int index, const Point& kell)
  {
    FKSteeringThreeComponentRayleighRadial& s=FKSteeringThreeComponentRayleighRadial::cache(cache, index);
    s.resize();
    s.initValue(kell, kell.z());
    //s.initGradient();
  }

  void FKSteeringThreeComponentRayleighRadial::initValue(const Point2D& k, double ellrad)
  {
    int stationCount=_array->count();
    int stationCount2=2*stationCount;
    Complex q, qc;
    double ell=::tan(ellrad);
    //_ell=::tan(ellrad);
    //_2ell=2.0*_ell;
    _ell2=ell*ell;
    /*_2inve=2.0/_ell;
    _4inv3e=2.0/3.0*_2inve;
    _8inv3e=2.0*_4inv3e;
    _2inv3e2=0.5/3.0*_2inve*_2inve;
    _ellFactor=cos(ellrad);
    _ellFactor=1.0/(_ellFactor*_ellFactor);
    _ellFactor2=_ellFactor*_ellFactor;*/
    Complex cell(0.0, -ell);
    _theta.set(k.x(), k.y());
    //_invk=1.0/k.length();
    for(int i=stationCount-1; i>=0; i--) {
      const Point2D& r=_array->relativePos(i);
      q.setUnitExp(-r.scalarProduct(k));
      _e.at(i+stationCount2, 0)=q;
      _eh.at(0, i+stationCount2)=conjugate(q);
      q*=cell;
      qc=conjugate(q);
      _e.at(i, 0)=q*_theta.cos();
      _eh.at(0, i)=qc*_theta.cos();
      _e.at(i+stationCount, 0)=q*_theta.sin();
      _eh.at(0, i+stationCount)=qc*_theta.sin();
    }
  }

#if 0
  /*!
    initValue() must be executed first.
  */
  void FKSteeringThreeComponentRayleighRadial::initGradient()
  {
    int stationCount=_array->count();
    int stationCount2=2*stationCount;
    _cosk=_theta.cos()*_invk;
    _sink=_theta.sin()*_invk;
    _ecosk=_ell*_cosk;
    _esink=_ell*_sink;
    for(int i=stationCount-1; i>=0; i--) {
      const Point2D& r=_array->relativePos(i);
      const Complex& ehE=_eh.at(0, i);
      const Complex& ehN=_eh.at(0, i+stationCount);
      const Complex& ehZ=_eh.at(0, i+stationCount2);
      Complex& thE=_th.at(0, i);
      Complex& thN=_th.at(0, i+stationCount);
      Complex& uhE=_uh.at(0, i);
      Complex& uhN=_uh.at(0, i+stationCount);
      _ehrx.at(0, i)=ehE*r.x();
      _ehry.at(0, i)=ehE*r.y();
      _ehrx.at(0, i+stationCount)=ehN*r.x();
      _ehry.at(0, i+stationCount)=ehN*r.y();
      _ehrx.at(0, i+stationCount2)=ehZ*r.x();
      _ehry.at(0, i+stationCount2)=ehZ*r.y();
      thE=ehZ*(-_theta.sin());
      thN=ehZ*_theta.cos();
      _th.at(0, i+stationCount2)=Complex::null;
      _t.at(i, 0)=conjugate(thE);
      _t.at(i+stationCount, 0)=conjugate(thN);
      _t.at(i+stationCount2, 0)=Complex::null;
      uhE=ehZ*_theta.cos();
      uhN=ehZ*_theta.sin();
      _uh.at(0, i+stationCount2)=Complex::null;
      _u.at(i, 0)=conjugate(uhE);
      _u.at(i+stationCount, 0)=conjugate(uhN);
      _u.at(i+stationCount2, 0)=Complex::null;
      _thrx.at(0, i)=thE*r.x();
      _thrx.at(0, i+stationCount)=thN*r.x();
      _thrx.at(0, i+stationCount2)=Complex::null;
      _thry.at(0, i)=thE*r.y();
      _thry.at(0, i+stationCount)=thN*r.y();
      _thry.at(0, i+stationCount2)=Complex::null;
      _uhrx.at(0, i)=uhE*r.x();
      _uhrx.at(0, i+stationCount)=uhN*r.x();
      _uhrx.at(0, i+stationCount2)=Complex::null;
      _uhry.at(0, i)=uhE*r.y();
      _uhry.at(0, i+stationCount)=uhN*r.y();
      _uhry.at(0, i+stationCount2)=Complex::null;
    }
  }

  /*!
    initGadient() must be executed first.
  */
  void FKSteeringThreeComponentRayleighRadial::initHessian()
  {
    int stationCount=_array->count();
    int stationCount2=2*stationCount;
    double einvk2=_ell*_invk*_invk;
    double esink2=_theta.sin()*einvk2;
    _ecos2k2=_theta.cos()*_theta.cos()*einvk2;
    _esin2k2=_theta.sin()*esink2;
    _ecossink2=_theta.cos()*esink2;
    _e2cossink2=_ell*_ecossink2;
    _e2sin2k2=_ell*_esin2k2;
    _e2cos2k2=_ell*_ecos2k2;
    for(int i=stationCount-1; i>=0; i--) {
      const Point2D& r=_array->relativePos(i);
      const Complex& eE=_e.at(i, 0);
      const Complex& eN=_e.at(i+stationCount, 0);
      const Complex& eZ=_e.at(i+stationCount2, 0);
      Complex& ehrxE=_ehrx.at(0, i);
      Complex& ehrxN=_ehrx.at(0, i+stationCount);
      Complex& ehrxZ=_ehrx.at(0, i+stationCount2);

      _ehrxrx.at(0, i)=ehrxE*r.x();
      _ehrxrx.at(0, i+stationCount)=ehrxN*r.x();
      _ehrxrx.at(0, i+stationCount2)=ehrxZ*r.x();

      _ehrxry.at(0, i)=ehrxE*r.y();
      _ehrxry.at(0, i+stationCount)=ehrxN*r.y();
      _ehrxry.at(0, i+stationCount2)=ehrxZ*r.y();

      _ehryry.at(0, i)=_ehry.at(0, i)*r.y();
      _ehryry.at(0, i+stationCount)=_ehry.at(0, i+stationCount)*r.y();
      _ehryry.at(0, i+stationCount2)=_ehry.at(0, i+stationCount2)*r.y();

      _rxe.at(i, 0)=eE*r.x();
      _rxe.at(i+stationCount, 0)=eN*r.x();
      _rxe.at(i+stationCount2, 0)=eZ*r.x();

      _rye.at(i, 0)=eE*r.y();
      _rye.at(i+stationCount, 0)=eN*r.y();
      _rye.at(i+stationCount2, 0)=eZ*r.y();
    }
  }
#endif

} // namespace ArrayCore

