/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2017-11-22
**  Copyright: 2017-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef FKCACHE_H
#define FKCACHE_H

#include <QGpCoreMath.h>

#include "ArraySelection.h"
#include "FKSteering.h"
#include "ArrayCoreDLLExport.h"

#define STEERING_CASE_COUNT 7

namespace ArrayCore {

  class ARRAYCORE_EXPORT FKCache
  {
  public:
    FKCache(const ArraySelection * array);
    ~FKCache();

    enum SteeringType {OneComponent=0,
                       TwoComponentRayleigh,
                       ThreeComponentRayleigh,
                       ThreeComponentRayleighFixedEll,
                       TwoComponentRadial,
                       TwoComponentTransverse,
                       TwoComponentRayleighFixedEll
                      };

    const ArraySelection * array() const {return _array;}

    bool isEmpty(SteeringType st) {return !_steering[st];}
    void resize(SteeringType st, int cacheItemCount);
    void reportCacheVolume(SteeringType st, int count, int sizeFactor) const;

    const FKSteering& steering(SteeringType st, int index) const {return _steering[st][index];}
    FKSteering& steering(SteeringType st, int index) {return _steering[st][index];}
  private:
    const ArraySelection * _array;
    FKSteering * _steering[STEERING_CASE_COUNT];
  };

} // namespace ArrayCore

#endif // FKCACHE_H

