/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-12-10
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "ArrayWorker.h"

namespace ArrayCore {

  /*!
    \class ArrayWorker ArrayWorker.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  ArrayWorker::ArrayWorker()
    : ParallelTaskWorker()
  {
    TRACE;
    _crossSpectrum=nullptr;
  }

  /*!
    Description of destructor still missing
  */
  ArrayWorker::~ArrayWorker()
  {
    TRACE;
    delete _crossSpectrum;
  }

  void ArrayWorker::process(ParallelTask * t)
  {
    ASSERT(_crossSpectrum);
    ArrayTask * at=static_cast<ArrayTask *>(t);
    const BlockAveragingParameters& param=_crossSpectrum->parameters()->blockAveraging();
    _crossSpectrum->setTimeWindows(at->timeWindows());
    const TimeWindowList& winList=_crossSpectrum->timeWindows()->list();
    while(!terminated()) {
      QVector<int> blocks=param.list(t->currentStep(), _crossSpectrum->stationCount(), winList);
      if(blocks.isEmpty()) {
        t->setFinishing();
        break;
      } else {
        t->addSteps(param.increment(winList, blocks));
        t->beginProcess(); // Avoid removal of task
        t->unlock();

        process(blocks);

        t->lock();
        t->endProcess();
      }
    }
    t->unlock();
  }

} // namespace ArrayCore

