/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-11-09
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ARRAYSELECTION_H
#define ARRAYSELECTION_H

#include "ArrayStations.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT ArraySelection
  {
  public:
    ArraySelection(const ArrayStations * array);
    ArraySelection(const ArraySelection * array);
    ~ArraySelection();

    const ArrayStations * array() const {return _array;}
    StationSignals::Components components() const {return _array->components();}
    ArrayStations::Mode mode() const {return _array->mode();}

    int count() const {return _selected.count();}
    bool isEmpty() const {return _selected.isEmpty();}
    void clear();
    const StationSignals * at(int index) const;

    void select(const Point& src, double minDistance, double maxDistance);
    void select(QVector<int> sel);

    const QVector<Point2D>& relativePos() const {return _relativePos;}
    const Point2D& relativePos(int station) const {return _relativePos.at(station);}

    enum Coordinates {Absolute, Relative};

    QString toString(Coordinates coord, int precision=2, char format='f') const;
  private:
    void setRelativePos();

    const ArrayStations * _array;
    const ArraySelection * _parent;
    QVector<int> _selected;
    QVector<Point2D> _relativePos;
  };

} // namespace ArrayCore

#endif // ARRAYSELECTION_H

