/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-03-19
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <GeopsyCore.h>
#include <QGpGuiTools.h>
#include <ArrayCore.h>

#include "WaranWidget.h"
#include "waranInstallPath.h"
#include "waranVersion.h"

PACKAGE_INFO("waran", WARAN)

ApplicationHelp * help();

int main(int argc, char ** argv)
{
  Application a(argc, argv, help);
  SciFigsGlobal s;

#if 0
  // Options
  double frequencyBandwidth=0.1;
  QString serverAddress, streamSelection;
  int serverPort=18000;
  // Check waran arguments
  int i, j=1;
  for(i=1; i<argc; i++) {
    QByteArray arg=argv[i];
    if(arg[0]=='-') {
      if(arg=="-band-width") {
        CoreApplication::checkOptionArg(i, argc, argv);
        frequencyBandwidth=CoreApplication::toInt(i, i-1, argv);
      } else if(arg=="-server") {
        CoreApplication::checkOptionArg(i, argc, argv);
        serverAddress=argv[i];
      } else if(arg=="-port") {
        CoreApplication::checkOptionArg(i, argc, argv);
        serverPort=CoreApplication::toInt(i, i-1, argv);
      } else if(arg=="-streams") {
        CoreApplication::checkOptionArg(i, argc, argv);
        streamSelection=argv[i];
      } else {
        App::log(tr("waran: bad option %1, see -help\n").arg(argv[i]) );
        return 2;
      }
    } else {
      argv[j++]=argv[i];
    }
  }
  if(j < argc) {
    argv[j]=nullptr;
    argc=j;
  }

  // Create the default geopsy database
  GeopsyCoreEngine gp;
  // Create main widget and start gui
  WaranWidget * w=new WaranWidget;
  w->setObjectName("waran");
  w->setfrequencyBandwidth(frequencyBandwidth);
  w->show();
  if(!serverAddress.isEmpty()) {
    w->seedlink->setServer(serverAddress, serverPort);
    w->seedlink->selectStreams(streamSelection);
  }
  int appReturn=a.exec();
  delete w;
  return appReturn;
#endif
  // Create the default geopsy database
  GeopsyCoreEngine gp;

  // Create main widget and start gui
  WaranWidget * w=new WaranWidget;
  w->setObjectName("waran");
  //w->setfrequencyBandwidth(frequencyBandwidth);
  w->show();

  int appReturn=a.exec();
  delete w;
  return appReturn;
}


ApplicationHelp * help()
{
  ApplicationHelp * h=new ApplicationHelp;
  h->setOptionSummary( "[OPTIONS]" );
  h->setComments( "Real time array processing. Connect to recording station through a Seed link signals are processed with "
                  "FK, HRFK and SPAC techniques in real time." );
  h->addGroup("Waran", "waran");
  h->addOption("-port <PORT>","Set the port number used by option '-server' (default=18000).");
  h->addOption("-streams <STREAMS>","Defines the streams to start (ignored if option '-server' is not specified). Specification "
               "of streams is either the same as for slinktool(SL) or regular expressions(RX):\n"
               "  RX:stream1[:selectors1],stream2[:selectors2],...\n"
               "  SL:stream1[:selectors1],stream2[:selectors2],...\n"
               "  'stream' is in NET_STA format, followed by a selection of streams. If no selector is given, "
               "all streams are started.\n"
               "  Examples:\n"
               "    \"RX:WA_WAU[0-9]{2}:HH.\n"
               "    \"SL:WA_WAU01:HHZ HHE HHN, WA_WAU02:HH?, WA_WAU03,...\"");
  return h;
}
