/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2013-04-08
**  Copyright: 2013-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef TAPEPOINT_H
#define TAPEPOINT_H

#include <QGpCoreMath.h>

class TapePoint : public NamedPoint
{
public:
  TapePoint() : NamedPoint() {_type=Free;}
  TapePoint(const QString& name) : NamedPoint(name, Point()) {_type=Free;}
  TapePoint(const TapePoint& o) : NamedPoint(o) {_type=o._type;}

  void operator=(const Point2D& o);

  enum Type {Fixed, North, Eastward, Free, Prior};

  static QString typeString(Type t);
  static Type type(const QString& t);

  Type type() const {return _type;}
  void setType(Type t) {_type=t;}
  QString typeString() const {return typeString(_type);}
  void setType(const QString& t) {setType(type(t));}

  void setStddev(const QGpCoreMath::Ellipse& e) {_stddev=e;}
  const QGpCoreMath::Ellipse& stddev() const {return _stddev;}
private:
  QGpCoreMath::Ellipse _stddev;
  Type _type;
};

#endif // TAPEPOINT_H
