/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2013-04-08
**  Copyright: 2013-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "TapeCoordinateDelegate.h"
#include "TapePoint.h"

/*!
  \class TapeCoordinateDelegate TapeCoordinateDelegate.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
TapeCoordinateDelegate::TapeCoordinateDelegate(QObject * parent)
  : QItemDelegate(parent)
{
  TRACE;
}

QWidget * TapeCoordinateDelegate::createEditor(QWidget * parent, const QStyleOptionViewItem &,
                                               const QModelIndex & index) const
{
  TRACE;
  switch (index.column()) {
  case 3: {
      QComboBox * w=new QComboBox(parent);
      w->addItem(tr("Fixed"));
      w->addItem(tr("North"));
      w->addItem(tr("Eastward"));
      w->addItem(tr("Free"));
      w->addItem(tr("Prior"));
      return w;
    }
  default: {
      QDoubleSpinBox * w=new QDoubleSpinBox(parent);
      w->setMinimum(-std::numeric_limits<double>::infinity());
      w->setMaximum(std::numeric_limits<double>::infinity());
      w->setSuffix(" m");
      w->setDecimals(3);
      w->setSingleStep(0.01);
      return w;
    }
  }
  return 0;
}

void TapeCoordinateDelegate::setEditorData(QWidget *editor, const QModelIndex &index) const
{
  TRACE;
  switch (index.column()) {
  case 3: {
      QComboBox * w=qobject_cast<QComboBox *>(editor);
      ASSERT(w);
      switch(TapePoint::type(index.model()->data(index).toString())) {
      case TapePoint::Fixed:
        w->setCurrentIndex(0);
        break;
      case TapePoint::North:
        w->setCurrentIndex(1);
        break;
      case TapePoint::Eastward:
        w->setCurrentIndex(2);
        break;
      case TapePoint::Free:
        w->setCurrentIndex(3);
        break;
      case TapePoint::Prior:
        w->setCurrentIndex(4);
        break;
      }
      break;
    }
  default: {
      QDoubleSpinBox * w=qobject_cast<QDoubleSpinBox *>(editor);
      ASSERT(w);
      w->setValue(index.model()->data(index).toDouble());
      break;
    }
  }
}

void TapeCoordinateDelegate::setModelData(QWidget *editor, QAbstractItemModel *model,
                                          const QModelIndex &index) const
{
  TRACE;
  switch (index.column()) {
  case 3: {
      QComboBox * w=qobject_cast<QComboBox *>(editor);
      ASSERT(w);
      switch(w->currentIndex()) {
      case 0:
        model->setData(index, TapePoint::typeString(TapePoint::Fixed));
        break;
      case 1:
        model->setData(index, TapePoint::typeString(TapePoint::North));
        break;
      case 2:
        model->setData(index, TapePoint::typeString(TapePoint::Eastward));
        break;
      case 3:
        model->setData(index, TapePoint::typeString(TapePoint::Free));
        break;
      case 4:
        model->setData(index, TapePoint::typeString(TapePoint::Prior));
        break;
      default:
        break;
      }
      break;
    }
  default: {
      QDoubleSpinBox * w=qobject_cast<QDoubleSpinBox *>(editor);
      ASSERT(w);
      model->setData(index, w->value());
      break;
    }
  }
}
