/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-09-05
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef STATION_H
#define STATION_H

#include <QGpCoreTools.h>

class CubeLink;
class GpsLink;
class SystemLink;
class NetLink;
class SeismicParameters;

class Station: public QObject
{
  Q_OBJECT
public:
  Station();
  ~Station();

  enum Type {AcquisitionUnit, ProcessingUnit, RepeaterUnit};

  const QString& name() const {return _name;}
  void setName(const QString& n) {_name=n;}

  Type type() const {return _type;}
  void setType(Type t);

  QString gpsFileName();
  QString currentGpsFileName() const {return _currentGpsFileName;}

  const QString& address() const {return _address;}
  void setAddress(const QString& a) {_address=a;}

  int index() const {return _index;}
  void setIndex(int i) {_index=i;}

  bool isAvailable();

  int frequency() const {return _frequency;}
  void setFrequency(int f);

  int hardwareGain() const {return _hardwareGain;}
  void setHardwareGain(int g);

  double numberOfBits() const {return _numberOfBits;}
  void setNumberOfBits(double n);

  const QString& seismicState() const {return _seismicState;}
  void setSeismicState(const QString& s);

  const QString& gpsState() const {return _gpsState;}
  void setGpsState(const QString& s);

  double diskSpace() const {return _diskSpace;}
  void setDiskSpace(double s);

  const QString& internalBattery() const {return _internalBattery;}
  void setInternalBattery(const QString& b);

  const QString& externalBattery() const {return _externalBattery;}
  void setExternalBattery(const QString& b);

  const QString& temperature() const {return _temperature;}
  void setTemperature(const QString& t);

  QString buddies() const {return _buddies;}
  void setBuddies(const QString& b);

  void requestComments();
  void addComment(const QString& c);

  QString comments() const {return _comments;}
  void setComments(const QString& c);

  QString linkState() const;

  void setSeismicParameters(const SeismicParameters& param);
  void startSeismic();
  void stopSeismic();
  void startGps(int duration);
  void stopGps();
  void navigationGps();
  void downloadGps();
  void abortDownloadGps();
  void reboot();
  void powerOff();
  void clearUsb();
signals:
  void dataChanged(int index);
  void commentsRefreshed(int index);
  void rawFileSize(int size);
  void rawFileReady();
  void rawFileError();
private:
  void clear();

  Type _type;
  QString _name, _buddies;
  QString _currentGpsFileName;
  QString _address;
  QString _seismicState, _gpsState;
  int _index;
  int _frequency, _hardwareGain;
  double _numberOfBits, _diskSpace;
  QString _internalBattery, _externalBattery, _temperature;
  QString _comments;

  CubeLink * _cubeLink;
  GpsLink * _gpsLink;
  SystemLink * _systemLink;
  NetLink * _netLink;
};

#endif // STATION_H

