/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-07-13
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "RealTimeStationSignals.h"

/*!
  \class RealTimeStationSignals RealTimeStationSignals.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
RealTimeStationSignals::RealTimeStationSignals(const StationSignals * originalSignals)
    : StationProcessSignals(originalSignals)
{
  TRACE;
}

/*!
  Description of destructor still missing
*/
RealTimeStationSignals::~RealTimeStationSignals()
{
  TRACE;
}

/*!
  Set processed signals for all components
*/
bool RealTimeStationSignals::setProcessed(const TimeRange& tw, const AbstractParameters * )
{
  TRACE;
  int nComp=nComponents();
  for(int iComp=0; iComp < nComp; iComp++) {
    if(!copyOriginalSignal(iComp, tw)) {
      return false;
    }
    DoubleSignal * sig=processed(iComp);
    //printf("nStart=%i nSamples=%i\n",nStart,nSamples);
    sig->subtractValue();
    // Set a 10% taper in time domain
    WindowFunctionParameters param;
    param.setShape(WindowFunctionParameters::Tukey);
    param.setAlpha(0.2);
    sig->taper(param);
    // Switch to frequency domain
    sig->fastFourierTransform(DoubleSignal::Spectrum);
    /*for(int i=0; i<nSamples/2;i++) 
      printf("%lg %lg\n",(double)i*_signals[0].processed->duration(),
            _signals[0].processed->spectrumAmplitude(i));*/
  }
  return true;
}
