/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-07-13
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PHASESHIFTER_H
#define PHASESHIFTER_H

#include <ArrayCore.h>

class PhaseShifter : public AbstractFunction
{
public:
  PhaseShifter(ArrayStations * array);
  ~PhaseShifter();

  void setMaximumSlowness(double slow) {_squaredSlowMax=slow*slow;}
  double maximumSlowness() const {return sqrt(_squaredSlowMax);}

  void setMaximumWavenumber(double k) {_squaredKmaxGrid=k*k;}

  void setSquaredOmega(double omega2);
  void setCrossSpectrum(ComplexMatrix m) {_crossSpectrum=m;}

  virtual bool initGrid(int n);
  virtual void initGrid(const Point& k, int index);
  virtual double value(const Point& k) const;
  virtual double value(const Point& k, int index) const;
private:
  // Maximum K^2 from grid limits
  double _squaredKmaxGrid;
  // Maximum slowness^2
  double _squaredSlowMax;
  // Maximum K^2 from grid limits and maximum slowness
  double _squaredKmaxTotal;

  QVector<Point2D> _relativePos;
  QVector< ComplexMatrix > _gridShifts;
  QVector< ComplexMatrix > _gridShiftConjugates;
  ComplexMatrix _crossSpectrum;
};

#endif // PHASESHIFTER_H
