/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2013-04-07
**  Copyright: 2013-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef DISTANCEWIDGET_H
#define DISTANCEWIDGET_H

#include <SciFigs.h>
#include <TapePositioningSystem.h>

#include "ui_DistanceWidget.h"

class Station;

class DistanceWidget : public QWidget, private Ui::DistanceWidget
{
  Q_OBJECT
public:
  DistanceWidget(QWidget * parent=nullptr);
  ~DistanceWidget();

  void setStations(QList<Station *> * list);
protected:
  bool eventFilter(QObject *obj, QEvent *event);
private slots:
  void on_addDistance_clicked();
  void on_removeDistance_clicked();
  void on_saveDistances_clicked();
  void on_loadDistances_clicked();
  void on_setPriorCoordinates_clicked();
  void on_saveCoordinates_clicked();
  void on_loadCoordinates_clicked();
  void updateCoordinateList();
  void updateCoordinates();
private:
  LineLayer * _rawLayer;
  NameLineLayer * _meanLayer;
  CircleViewer * _covarianceLayer;
  SortedStringList _pointNames;
};

#endif // DISTANCEWIDGET_H
