/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2013-04-07
**  Copyright: 2013-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef DISTANCEITEM_H
#define DISTANCEITEM_H

#include <QGpCoreTools.h>

#include "Distance.h"

class DistanceItem : public QAbstractTableModel
{
  Q_OBJECT
public:
  DistanceItem(QObject * parent, SortedStringList * pointNames);
  ~DistanceItem();

  QList<Distance>& distances() {return _distances;}
  const QList<Distance>& distances() const {return _distances;}

  virtual int rowCount(const QModelIndex& parent) const;
  virtual int	columnCount(const QModelIndex& parent) const;
  virtual QVariant data(const QModelIndex & index, int role) const;
  virtual bool setData(const QModelIndex & index, const QVariant & value, int role=Qt::EditRole);
  virtual QVariant headerData(int section, Qt::Orientation orientation, int role) const;
  Qt::ItemFlags flags(const QModelIndex& index) const;

  void add();
  void remove(int index);
  bool load(const QString& fileName);
  bool save(const QString& fileName) const;
signals:
  void pointNameChanged();
  void distanceChanged();
private:
  QString nextPointName(const QString& n);

  QList<Distance> _distances;
  SortedStringList * _pointNames;
};

#endif // DISTANCEITEM_H
