/***************************************************************************
**
**  This file is part of gpviewmax.
**
**  gpviewmax is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpviewmax is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-07-19
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "Samples.h"

/*!
  \class Samples Samples.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

void Samples::sort()
{
  TRACE;
  std::sort(begin(), end(), lessThan);
}

bool Samples::lessThan(const Sample& s1, const Sample& s2)
{
  if(s1.frequency()<s2.frequency()) {
    return true;
  } else if(s1.frequency()>s2.frequency()) {
    return false;
  } else {
    if(s1.time()<s2.time()) {
      return true;
    } else if(s1.time()>s2.time()) {
      return false;
    } else {
      return s1.ring()<s2.ring();
    }
  }
}

