/***************************************************************************
**
**  This file is part of phaseit.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-08-09
**  Authors:
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef TOOLWIDGET_H
#define TOOLWIDGET_H

#include <GeopsyGui.h>

#include "ui_ToolWidget.h"
#include "Tool.h"

class ToolWidget: public AbstractToolWidget, public Ui::ToolWidget
{
  Q_OBJECT
public:
  ToolWidget(QWidget * parent);

  void restoreFields();
  void updateAllFields();

  bool setSubPool(SubSignalPool * subPool);

  Tool * tool() {return static_cast<Tool *>(_tool);}
  const Tool * tool() const {return static_cast<const Tool *>(_tool);}
public slots:
  void start();
  void stop();
private slots:
  void autoWindows();
  void inverseWindows();
  void addWindows(const TimeRange& r);
  void removeWindows(const TimeRange& r);
  void beginAddWindowsManually();
  void endAddWindowsManually();
  void beginRemoveWindowsManually();
  void endRemoveWindowsManually();
  void manualAddWindows(const Signal *, const TimeRange& r);
  void manualRemoveWindows(const Signal *, const TimeRange& r);
  void clearWindows();
  void loadWindows(QString fileName=QString());
  void finish();
protected:
  void setParameters(const AbstractParameters * param);
  AbstractParameters * parameters(AbstractParameters * param=nullptr) const;
private:
  void setReferenceList();
  bool updateParameters();
  void getParameters(Parameters& param) const;
  void setParameters(const Parameters& param);
  void setRunning(bool r, const QString& message=QString());
  bool hasWindows();
  void windowsChanged();
  void setStationPlots();

  QRect * _trackingRect;
  Signal * _trackedSignal;
};

#endif // TOOLWIDGET_H
