/***************************************************************************
**
**  This file is part of phaseit.
**
**  phaseit is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  phaseit is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-11-04
**  Copyright: 2016
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef CURVERESULTS_H
#define CURVERESULTS_H

#include <SciFigs.h>

#include "TaskManager.h"

class CurveResults : public GraphicSheetMenu
{
public:
  CurveResults(QWidget * parent=nullptr);
  ~CurveResults();

  void setResultCount(int n);
  void setName(int ig, const QString& name);
  void setValues(const TaskManager * tm);
  void setLayout(double pageHeight);
private:
  void setAxis(AxisWindow * w);

  int _resultCount;
  TextEdit ** _comments;
  LineLayer ** _coherence;
  LineLayer ** _phase;
  LineLayer ** _amplitude;
};

#endif // CURVERESULTS_H

