/***************************************************************************
**
**  This file is part of phaseit.
**
**  phaseit is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  phaseit is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-11-04
**  Copyright: 2016
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include <GeopsyGui.h>

#include "CurveResults.h"

/*!
  \class CurveResults CurveResults.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
CurveResults::CurveResults(QWidget * parent)
  : GraphicSheetMenu(parent)
{
  TRACE;
  setGeometry(5, 80, 500, 500);
  setWindowTitle(tr("Curve results"));
  sheet()->pageSize().setOrientation(QPageLayout::Landscape);

  _comments=nullptr;
  _coherence=nullptr;
  _phase=nullptr;
  _amplitude=nullptr;
}

/*!
  Description of destructor still missing
*/
CurveResults::~CurveResults()
{
  TRACE;
  delete [] _comments;

  delete [] _coherence;
  delete [] _phase;
  delete [] _amplitude;
}

void CurveResults::setAxis(AxisWindow * w)
{
  TRACE;
  w->xAxis()->setTitle(tr("Frequency (hz)"));
  w->xAxis()->setScaleType(Scale::Log);
  w->xAxis()->setTitleInversedScale(tr("Period (s)"));
  w->xAxis()->setRange(0.2, 20.0);
}

void CurveResults::setResultCount(int n)
{
  TRACE;
  sheet()->setStatusBar(GeopsyGuiEngine::instance()->statusBar());
  double y=0.5;
  _resultCount=n;
  _comments=new TextEdit*[_resultCount];
  _coherence=new LineLayer*[_resultCount];
  _phase=new LineLayer*[_resultCount];
  _amplitude=new LineLayer*[_resultCount];
  AxisWindow * w;
  PlotLine2D * line;
  for(int ig=0; ig<_resultCount; ig++) {
    GraphicObjectGroup * g=new GraphicObjectGroup;

    w=new AxisWindow;
    w->setObjectName("coherencePlot");
    setAxis(w);
    w->yAxis()->setTitle(tr("Coherence (%)"));
    w->yAxis()->setRange(0.0, 100.0);
    _coherence[ig]=new LineLayer(w);
    line=new PlotLine2D;
    line->setPen(Pen(Qt::black, 0.1, Qt::SolidLine));
    line->setSymbol(Symbol());
    _coherence[ig]->setReferenceLine(line);
    w->setGeometry(0.5, 0.0, 9.0, 6.0);
    g->addObject(w);

    w=new AxisWindow;
    w->setObjectName("phasePlot");
    setAxis(w);
    w->yAxis()->setTitle(tr("Phase (%)"));
    w->yAxis()->setRange(-18.0, 18.0);
    _phase[ig]=new LineLayer(w);
    line=new PlotLine2D;
    line->setPen(Pen(Qt::black, 0.1, Qt::SolidLine));
    line->setSymbol(Symbol());
    _phase[ig]->setReferenceLine(line);
    w->setGeometry(9.5, 0.0, 9.0, 6.0);
    g->addObject(w);

    w=new AxisWindow;
    w->setObjectName("amplitudePlot");
    setAxis(w);
    w->yAxis()->setTitle(tr("Spectral ratio"));
    w->yAxis()->setScaleType(Scale::Log);
    w->yAxis()->setRange(0.5, 2.0);
    _amplitude[ig]=new LineLayer(w);
    line=new PlotLine2D;
    line->setPen(Pen(Qt::black, 0.1, Qt::SolidLine));
    line->setSymbol(Symbol());
    _amplitude[ig]->setReferenceLine(line);
    w->setGeometry(18.5, 0.0, 9.0, 6.0);
    g->addObject(w);

    _comments[ig]=new TextEdit;
    _comments[ig]->setObjectName("label");
    _comments[ig]->setAnchor(GraphicObject::BottomRight);
    _comments[ig]->setGeometry(27.5, 0, 4.0, 0.5);
    g->addObject(_comments[ig]);

    sheet()->addObject(g);
    g->resize();
    g->setPrintLeft(0.5);
    g->setPrintTop(y);
    g->updateGeometry();
    y+=6.5;
  }
}

void CurveResults::setName(int ig, const QString& name)
{
  TRACE;
  _comments[ig]->setText(name);
  _comments[ig]->update();
}

void CurveResults::setValues(const TaskManager * tm)
{
  TRACE;
  ASSERT(_resultCount==tm->stations()->count()-1);
  AxisWindow * w;
  for(int ig=0; ig<_resultCount; ig++) {
    w=_coherence[ig]->graph();
    const IrregularGrid2D& gcoherence=tm->coherenceGrid(ig);
    _coherence[ig]->clear();
    for(int i=0; i<gcoherence.nx(); i++) {
      PlotLine2D * line=static_cast<PlotLine2D *>(_coherence[ig]->addLine());
      line->setCurve(gcoherence.crossSection(YAxis, i));
    }
    w->xAxis()->setRange(gcoherence.y(0), gcoherence.y(gcoherence.ny()-1));

    w=_phase[ig]->graph();
    const IrregularGrid2D& gphase=tm->phaseGrid(ig);
    _phase[ig]->clear();
    for(int i=0; i<gphase.nx(); i++) {
      PlotLine2D * line=static_cast<PlotLine2D *>(_phase[ig]->addLine());
      line->setCurve(gphase.crossSection(YAxis, i));
    }
    w->xAxis()->setRange(gphase.y(0), gphase.y(gphase.ny()-1));

    w=_amplitude[ig]->graph();
    const IrregularGrid2D& gamplitude=tm->amplitudeGrid(ig);
    _amplitude[ig]->clear();
    for(int i=0; i<gamplitude.nx(); i++) {
      PlotLine2D * line=static_cast<PlotLine2D *>(_amplitude[ig]->addLine());
      line->setCurve(gamplitude.crossSection(YAxis, i));
    }
    w->xAxis()->setRange(gamplitude.y(0), gamplitude.y(gamplitude.ny()-1));
  }
}

void CurveResults::setLayout(double pageHeight)
{
  TRACE;
  QList<GraphicObject *> objects;
  for(int i=0; i<_resultCount; i++) {
    objects.append(_amplitude[i]->graph()->absoluteGroup());
  }
  GraphicObject::setLayout(objects, 0, pageHeight);
}
