/***************************************************************************
**
**  This file is part of matfiles.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-07-22
**  Authors:
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MATLABVARIABLENAME_H
#define MATLABVARIABLENAME_H

#include <GeopsyCore.h>

class MatlabVariableName : public MetaString
{
  METADATA_CLASS(MatlabVariableName)
public:
  MatlabVariableName() {}
  MatlabVariableName(const QString& n) {setValue(n);}
  MatlabVariableName(const MatlabVariableName& o) : MetaString(o) {}

  virtual QStringList subNames() const;
  virtual QString name(int, const QString&) const;
  virtual QString baseName(int) const;
  virtual QString title(int, const QString&) const;

  virtual bool isReadOnly(int) const {return true;}
};

#endif // MATLABVARIABLENAME_H
